{*
 * Copyright ETS Software Technology Co., Ltd
 *
 * NOTICE OF LICENSE
 *
 * This file is not open source! Each license that you purchased is only available for 1 website only.
 * If you want to use this file on more websites (or projects), you need to purchase additional licenses.
 * You are not allowed to redistribute, resell, lease, license, sub-license or offer our resources to any third party.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future.
 *
 * @author ETS Software Technology Co., Ltd
 * @copyright  ETS Software Technology Co., Ltd
 * @license    Valid for 1 website (or project) for each purchase of license
*}

{extends file="helpers/form/form.tpl"}
{block name="legend"}
    {$smarty.block.parent}
    
    {if isset($steps) && $steps|count > 0}
        <ul class="ets-em-nav-steps">
            {assign var="ik" value=0}
            {foreach from=$steps item='name'}
                {assign var="ik" value=$ik+1}
                <li class="ets-em-nav-step step{$ik|intval}{if $current_step|intval === $ik|intval} active{/if}" data-step="{$ik|intval}">
                    <span class="img_step img_step_{$ik|escape:'quotes':'UTF-8'}"></span><br />
                    <i class="step">0{$ik|intval}</i><br />{$name|escape:'quotes':'UTF-8'}
                </li>
            {/foreach}
        </ul>
        <input id="current_step" name="current_step" value="{$current_step|intval}" type="hidden" />
    {/if}
    <div class="form_header_block h_step1 step1" data-step="1">
        <h2 class="text-center">{l s='Connect' mod='ets_migrator'}</h2>
        <p class="title_sub">{l s='Download and install [2]PrestaShop Connector module[/2] on source store then enter [1]Source store URL[/1] and [1]Access token[/1] into the form below to establish connection' tags=['<b>','<b>'] mod='ets_migrator'}</p>
        <h4>
            <a href="{$download_plugin_link|cat:'&file=ets_migrate_connector.zip'|escape:'quotes':'UTF-8'}" target="_blank">
                <svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1344 1344q0-26-19-45t-45-19-45 19-19 45 19 45 45 19 45-19 19-45zm256 0q0-26-19-45t-45-19-45 19-19 45 19 45 45 19 45-19 19-45zm128-224v320q0 40-28 68t-68 28h-1472q-40 0-68-28t-28-68v-320q0-40 28-68t68-28h465l135 136q58 56 136 56t136-56l136-136h464q40 0 68 28t28 68zm-325-569q17 41-14 70l-448 448q-18 19-45 19t-45-19l-448-448q-31-29-14-70 17-39 59-39h256v-448q0-26 19-45t45-19h256q26 0 45 19t19 45v448h256q42 0 59 39z"/></svg>
                 {l s='Download PrestaShop Connector module' mod='ets_migrator'}
            </a>
        </h4>
    </div>
    <div class="form_header_block h_step2 step2" data-step="2">
        <h2 class="text-center">{l s='Migration' mod='ets_migrator'}</h2>
        <p class="title_sub">
            {l s='Selected data entities indicated below will be migrated. By default, all data entities are selected.' mod='ets_migrator'}<br/>
            {l s='Click [1]"Next"[/1] to go to [1]Advanced settings[/1] step for more migration options.' tags=['<b>'] mod='ets_migrator'}
        </p>
    </div>
{/block}

{block name="label"}
    {if $prestashop_15}
        {if $input.name == 'ETS_MG_DOMAIN'}
            {if isset($steps) && $steps|count > 0}
                <ul class="ets-em-nav-steps">
                    {assign var="ik" value=0}
                    {foreach from=$steps item='name'}
                        {assign var="ik" value=$ik+1}
                        <li class="ets-em-nav-step step{$ik|escape:'quotes':'UTF-8'}{if $current_step|intval === $ik|intval} active{/if}" data-step="{$ik|escape:'quotes':'UTF-8'}">
                            <span class="img_step img_step_{$ik|escape:'quotes':'UTF-8'}"></span><br />
                            <i class="step">0{$ik|intval}</i><br />{$name|escape:'quotes':'UTF-8'}
                        </li>
                    {/foreach}
                </ul>
                <input id="current_step" name="current_step" value="{$current_step|intval}" type="hidden" />
            {/if}
            <div class="form_header_block h_step1 step1" data-step="1">
                <h2 class="text-center">{l s='Connect' mod='ets_migrator'}</h2>
                <p class="title_sub">{l s='Download and install' mod='ets_migrator'} <b>{l s='PrestaShop Connector module' mod='ets_migrator'}</b> {l s='on source store then enter' mod='ets_migrator'} <b>{l s='Source store URL' mod='ets_migrator'}</b> {l s='and' mod='ets_migrator'} <b>{l s='Access token' mod='ets_migrator'}</b> {l s='into the form below to establish connection' mod='ets_migrator'}</p>
                <h4>
                    <a href="{$download_plugin_link|cat:'&file=ets_migrate_connector.zip'|escape:'quotes':'UTF-8'}" target="_blank">
                        <svg class="w_14 h_14" width="14" height="14" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1344 1344q0-26-19-45t-45-19-45 19-19 45 19 45 45 19 45-19 19-45zm256 0q0-26-19-45t-45-19-45 19-19 45 19 45 45 19 45-19 19-45zm128-224v320q0 40-28 68t-68 28h-1472q-40 0-68-28t-28-68v-320q0-40 28-68t68-28h465l135 136q58 56 136 56t136-56l136-136h464q40 0 68 28t28 68zm-325-569q17 41-14 70l-448 448q-18 19-45 19t-45-19l-448-448q-31-29-14-70 17-39 59-39h256v-448q0-26 19-45t45-19h256q26 0 45 19t19 45v448h256q42 0 59 39z"/></svg>
                        {l s='Download PrestaShop Connector module' mod='ets_migrator'}
                    </a>
                </h4>
            </div>
            <div class="form_header_block h_step2 step2" data-step="2">
                <h2 class="text-center">{l s='Migration' mod='ets_migrator'}</h2>
                <p class="title_sub">
                    {l s='Selected data entities indicated below will be migrated. By default, all data entities are selected.' mod='ets_migrator'}<br/>
                    {l s='Click ' mod='ets_migrator'} 
                    <b>{l s='Advanced settings' mod='ets_migrator'}</b> 
                    {l s='for more migration options.' mod='ets_migrator'}
                </p>
            </div>
        {/if}
        {if isset($steps) && $steps}
            {if !isset($ik2)}{assign var="ik2" value=0}{else}{assign var="ik2" value=$ik2+1}{/if}
            {if !isset($form_group_step)}
                {assign var="form_group_step" value=$input.step}
                <div class="form-wrapper-group-step{if $input.step == 3} step5{elseif $input.step == 4} step6{else} step{$input.step|escape:'quotes':'UTF-8'}{/if}{if $current_step|intval === $input.step|intval} active{/if}{if $input.step == 2} step3 step4{/if}" data-step="{$input.step|escape:'quotes':'UTF-8'}">
            {/if}
            {if $form_group_step == $input.step}
                {if isset($input.group_title) && $input.group_title|trim !== '' && $input.name|trim !== 'ETS_MG_DATA_TO_MIGRATE'}
                    <h4 class="ets_em_title_block">{$input.group_title|escape:'quotes':'UTF-8'}</h4>
                {/if}
                <div class="form-group {$input.name|lower|escape:'html':'UTF-8'}{if isset($input.form_group_class)} {$input.form_group_class|lower|escape:'html':'UTF-8'}{/if}">
                    {$smarty.block.parent}
            {elseif $form_group_step != $input.step}
                {assign var="form_group_step" value=$input.step}
                </div>
                <div class="form-wrapper-group-step{if $input.step == 3} step5{elseif $input.step == 4} step6{else} step{$input.step|escape:'quotes':'UTF-8'}{/if}{if $current_step|intval === $input.step|intval} active{/if}{if $input.step == 2} step3 step4{/if}" data-step="{$input.step|escape:'quotes':'UTF-8'}">
                {if !empty($input.group_title)}
                    <h4 class="ets_em_title_block">{$input.group_title|escape:'quotes':'UTF-8'}</h4>
                {/if}
                {if $input.name == 'ETS_MG_DATA_TO_MIGRATE'}
                    <div class="form-group data-to-migrate">
                        <div class="ets_mg_import_info">
                            <div class="ets_mg_wrap">
                                <div class="title_form col-sm-6 col-xs-6">{l s='Data entities' mod='ets_migrator'}</div>
                                <div class="title_form title_form_items col-sm-6 col-xs-6">{l s='Item count' mod='ets_migrator'}</div>
                                {include file="./data-migrate.tpl" class='info_data_source' type='column' input_checkbox=0}
                            </div>
                            <div class="ets_mg_bottom viewmore_form">
                                <span class="viewmore_button more active">{l s='View more' mod='ets_migrator'}</span>
                                <span class="viewmore_button less">{l s='View less' mod='ets_migrator'}</span>
                            </div>
                        </div>
                    </div>
                    <div class="form-group wrap-migrate">
                        <div class="table">
                            <div class="table-cell">
                                <div class="ets_em_form">
                                    <div class="ets_em_form_group advanced_settings">
                                        <div class="ets_em_panel_header">
                                            <div class="ets_em_header_block">
                                                <h3 class="ets_em_title_block">{l s='Advanced settings' mod='ets_migrator'}</h3>
                                            </div>
                                        </div>
                                        <div class="form-group data-entities advanced_settings">
                                            <h4 class="ets_em_title_block">{l s='Data entities to migrate' mod='ets_migrator'}</h4>
                                            <div class="ets_mg_export_import_form">
                                                {include file="./data-migrate.tpl" class='select_data_import' type='list' input_checkbox=1}
                                            </div>
                                        </div>
                                        <div class="form-group ets-em-shop-mapping advanced_settings">
                                            <h4 class="ets_em_title_block">{l s='Shop mapping' mod='ets_migrator'}</h4>
                                            <input id="ETS_MG_SHOPS_MAPPING" type="hidden" name="ETS_MG_SHOPS_MAPPING" value=""/>
                                            <div class="ets-em-shop-mapping-list"></div>
                                        </div>
                                        <div class="form-group {$input.name|lower|escape:'html':'UTF-8'}{if isset($input.form_group_class)} {$input.form_group_class|lower|escape:'html':'UTF-8'}{/if}">
                                            {$smarty.block.parent}
                {elseif $input.name == 'ETS_MG_PROCESS_MIGRATION'}
                    <div class="form-group process-migration">
                        {include file="./migrate-process.tpl"}
                {elseif $input.name == 'ETS_MG_MIGRATION_DONE'}
                    <div class="form-group migration-done">
                        {include file="./migrate-complete.tpl"}
                {else}
                    <div class="form-group {$input.name|lower|escape:'html':'UTF-8'}{if isset($input.form_group_class)} {$input.form_group_class|lower|escape:'html':'UTF-8'}{/if}">
                        {$smarty.block.parent}
                {/if}
            {/if}
        {else}
            <div class="form-group {$input.name|lower|escape:'html':'UTF-8'}{if isset($input.form_group_class)} {$input.form_group_class|lower|escape:'html':'UTF-8'}{/if}">
                {$smarty.block.parent}
        {/if}
    {else}{$smarty.block.parent}{/if}
{/block}
{block name="field"}
    {if $prestashop_15}
        {if isset($steps) && $steps}
            {if $form_group_step == $input.step}
                {$smarty.block.parent}</div>
                {if $input.name == 'ETS_MG_MIGRATE_SPEED' && (!isset($partial) || $partial|trim == '')}
                    {include file="./form-footer.tpl" show_btn_cancel=true}
                {/if}
                {if $input.name == 'ETS_MG_MANUFACTURER_DEFAULT'}
                    </div>
                    <div class="ets_em_form_group migrate_review">
                        {include file="./migrate-review.tpl"}
                    </div>
                    <div class="ets_em_form_group migrate_resume">
                        {include file="./migrate-resume.tpl"}
                    </div>
                {/if}
                {if $input.name == 'ETS_MG_MIGRATE_SPEED'}
                                </div>
                            </div>
                        </div>
                    </div>
                {/if}
            {elseif $form_group_step != $input.step}
                {if $input.name != 'ETS_MG_DATA_TO_MIGRATE' && $input.name != 'ETS_MG_PROCESS_MIGRATION' && $input.name != 'ETS_MG_MIGRATION_DONE'}
                    {$smarty.block.parent}
                {/if}</div>
            {/if}
        {else}
            {$smarty.block.parent}</div>
        {/if}
        {if $input.name == 'ETS_MG_MIGRATION_DONE'}
            </div>
            {if isset($partial) && $partial|trim !== ''}
                <div class="form-footer">
                    <input type="hidden" value="{$partial|escape:'html':'UTF-8'}" name="partial">
                    <button name="module_form_cancel_btn" type="button" class="btn btn-default ets_em_popup_cancel no_svg_icon">{l s='Close' mod='ets_migrator'}</button>
                    <button type="submit" value="1" class="ets_em_form_submit_btn no_svg_icon ets_em_setting" name="submitConfig">{l s='Save' mod='ets_migrator'}</button>
                </div>
            {else}
                <div class="panel-form-footer step1" data-step="{$input.step|escape:'quotes':'UTF-8'}">
                    <button type="submit" value="1" class="ets_em_form_submit_btn" name="submitConfig">
                        {l s='Next' mod='ets_migrator'}
                        <i class="ets_svg_icon ets_svg_fill_white">
                            <svg class="w_18 h_18" width="18" height="18" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1728 893q0 14-10 24l-384 354q-16 14-35 6-19-9-19-29v-224h-1248q-14 0-23-9t-9-23v-192q0-14 9-23t23-9h1248v-224q0-21 19-29t35 5l384 350q10 10 10 23z"/></svg>
                        </i>
                    </button>
                </div>
                <div class="panel-form-footer step2">
                    <button type="submit" id="ets_em_advance_popup" class="ets_em_advanced_settings pull-right">
                        {l s='Next' mod='ets_migrator'}
                        <i class="ets_svg_icon ets_svg_fill_white">
                            <svg class="w_18 h_18" width="18" height="18" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1728 893q0 14-10 24l-384 354q-16 14-35 6-19-9-19-29v-224h-1248q-14 0-23-9t-9-23v-192q0-14 9-23t23-9h1248v-224q0-21 19-29t35 5l384 350q10 10 10 23z"/></svg>
                        </i>
                    </button>
                    <button type="submit" class="back_step1">

                            <svg class="w_18 h_18" width="18" height="18" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1792 800v192q0 14-9 23t-23 9h-1248v224q0 21-19 29t-35-5l-384-350q-10-10-10-23 0-14 10-24l384-354q16-14 35-6 19 9 19 29v224h1248q14 0 23 9t9 23z"/></svg>
                         {l s='Back' mod='ets_migrator'}
                    </button>
                </div>
            {/if}
        {/if}
        {if isset($partial) && $partial|trim !== '' && $input.name == 'ETS_MG_MIGRATE_SPEED'}
            <div class="form-footer">
                <input type="hidden" value="{$partial|escape:'html':'UTF-8'}" name="partial">
                <button name="module_form_cancel_btn" type="button" class="btn btn-default ets_em_popup_cancel no_svg_icon">{l s='Close' mod='ets_migrator'}</button>
                <button type="submit" value="1" class="ets_em_form_submit_btn no_svg_icon ets_em_setting" name="submitConfig">{l s='Save' mod='ets_migrator'}</button>
            </div>
        {/if}
    {else}{$smarty.block.parent}{/if}
{/block}
{block name="input"}
    {if $input.type=='range'}
        <div class="ets_range_input">
            <div class="range_title">
                <span class="low">{l s='Low' mod='ets_migrator'}</span>
                <span class="medium">{l s='Medium' mod='ets_migrator'}</span>
                <span class="high">{l s='High' mod='ets_migrator'}</span>
            </div>
            <span id="{$input.name|escape:'html':'UTF-8'}_value">{if isset($fields_value[$input.name]) && $fields_value[$input.name]|intval}{$fields_value[$input.name]|intval}{else}200{/if}</span>
            <input type="range" id="{$input.name|escape:'html':'UTF-8'}" name="{$input.name|escape:'html':'UTF-8'}" min="{$input.min|intval}" max="{$input.max|intval}" step="100" value="{if isset($fields_value[$input.name]) && $fields_value[$input.name]|intval}{$fields_value[$input.name]|intval}{else}200{/if}">
            <div class="ets_range_input_slide">
                <span class="ets_range_input_val"></span>
            </div>
        </div>
    {elseif $input.type=='radio'}
        {foreach $input.values as $value}
			<div class="radio {if isset($input.class)}{$input.class|escape:'html':'UTF-8'}{/if}">
				{strip}
				<label class="ets_custom_radio">
				    <input type="radio"	name="{$input.name|escape:'html':'UTF-8'}" id="{$value.id|escape:'html':'UTF-8'}" value="{$value.value|escape:'html':'UTF-8'}"{if $fields_value[$input.name] == $value.value} checked="checked"{/if}{if (isset($input.disabled) && $input.disabled) or (isset($value.disabled) && $value.disabled)} disabled="disabled"{/if}/>
					<div class="ets_checkbox"></div>
                    {$value.label|escape:'quotes':'UTF-8'}
				</label>
				{/strip}
			</div>
			{if isset($value.p) && $value.p}<p class="help-block">{$value.p|escape:'html':'UTF-8'}</p>{/if}
		{/foreach}
    {else}
        {if $input.name|trim === 'ETS_MG_DOMAIN'}
            <div class="ETS_MG_DOMAIN">
                {$smarty.block.parent}
                <span class="ets_em_tooltip ets_em_domain">
                    <i class="ets_svg_icon svg_fill_blue svg_fill_hover_gray">
                        <svg class="w_20 h_20" width="20" height="20" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1024 1376v-192q0-14-9-23t-23-9h-192q-14 0-23 9t-9 23v192q0 14 9 23t23 9h192q14 0 23-9t9-23zm256-672q0-88-55.5-163t-138.5-116-170-41q-243 0-371 213-15 24 8 42l132 100q7 6 19 6 16 0 25-12 53-68 86-92 34-24 86-24 48 0 85.5 26t37.5 59q0 38-20 61t-68 45q-63 28-115.5 86.5t-52.5 125.5v36q0 14 9 23t23 9h192q14 0 23-9t9-23q0-19 21.5-49.5t54.5-49.5q32-18 49-28.5t46-35 44.5-48 28-60.5 12.5-81zm384 192q0 209-103 385.5t-279.5 279.5-385.5 103-385.5-103-279.5-279.5-103-385.5 103-385.5 279.5-279.5 385.5-103 385.5 103 279.5 279.5 103 385.5z"/></svg>
                    </i> <span class="ets_tooltip top">{l s='Enter source store URL (home page URL of the source store) including http:// or https://' mod='ets_migrator'}</span>
                </span>
            </div>
        {elseif $input.name|trim === 'ETS_MG_ACCESS_TOKEN'}
            <div class="ETS_MG_ACCESS_TOKEN">
                {$smarty.block.parent}
                <span class="ets_em_tooltip ets_em_domain">
                    <i class="ets_svg_icon svg_fill_blue svg_fill_hover_gray">
                        <svg class="w_20 h_20" width="20" height="20" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1024 1376v-192q0-14-9-23t-23-9h-192q-14 0-23 9t-9 23v192q0 14 9 23t23 9h192q14 0 23-9t9-23zm256-672q0-88-55.5-163t-138.5-116-170-41q-243 0-371 213-15 24 8 42l132 100q7 6 19 6 16 0 25-12 53-68 86-92 34-24 86-24 48 0 85.5 26t37.5 59q0 38-20 61t-68 45q-63 28-115.5 86.5t-52.5 125.5v36q0 14 9 23t23 9h192q14 0 23-9t9-23q0-19 21.5-49.5t54.5-49.5q32-18 49-28.5t46-35 44.5-48 28-60.5 12.5-81zm384 192q0 209-103 385.5t-279.5 279.5-385.5 103-385.5-103-279.5-279.5-103-385.5 103-385.5 279.5-279.5 385.5-103 385.5 103 279.5 279.5 103 385.5z"/></svg>
                    </i> <span class="ets_tooltip top">{l s='Copy Access token from "PrestaShop Connector" installed on the source store' mod='ets_migrator'}</span>
                </span>
            </div>
        {else}
            {$smarty.block.parent}
        {/if}
    {/if}
{/block}

{block name="input_row"}
    {if isset($steps) && $steps && !$prestashop_15}
        {if !isset($ik2)}{assign var="ik2" value=0}{else}{assign var="ik2" value=$ik2+1}{/if}
        {if !isset($form_group_step)}
            {assign var="form_group_step" value=$input.step}
            <div class="form-wrapper-group-step{if $input.step == 3} step5{elseif $input.step == 4} step6{else} step{$input.step|escape:'quotes':'UTF-8'}{/if}{if $current_step|intval === $input.step|intval} active{/if}{if $input.step == 2} step3 step4{/if}" data-step="{$input.step|escape:'quotes':'UTF-8'}">
        {/if}
        {if $form_group_step == $input.step}
            {if isset($input.group_title) && $input.group_title|trim !== '' && $input.name|trim !== 'ETS_MG_DATA_TO_MIGRATE'}
                <h4 class="ets_em_title_block">{$input.group_title|escape:'quotes':'UTF-8'}</h4>
            {/if}
            {$smarty.block.parent}
            {if $input.name == 'ETS_MG_MIGRATE_VERSION'}
                {include file="./form-footer.tpl" show_btn_cancel=true}
            {/if}
            {if $input.name == 'ETS_MG_MANUFACTURER_DEFAULT'}
                </div>
                <div class="ets_em_form_group migrate_review">
                    {include file="./migrate-review.tpl"}
                </div>
                <div class="ets_em_form_group migrate_resume">
                    {include file="./migrate-resume.tpl"}
                </div>
            {/if}
            {if $input.name == 'ETS_MG_MIGRATE_VERSION'}
                        </div>
                    </div>
                </div>
            </div>
            {/if}
        {elseif $form_group_step != $input.step}
            {assign var="form_group_step" value=$input.step}
            </div>
            <div class="form-wrapper-group-step{if $input.step == 3} step5{elseif $input.step == 4} step6{else} step{$input.step|escape:'quotes':'UTF-8'}{/if}{if $current_step|intval === $input.step|intval} active{/if}{if $input.step == 2} step3 step4{/if}" data-step="{$input.step|escape:'quotes':'UTF-8'}">
            {if !empty($input.group_title)}
                <h4 class="ets_em_title_block">{$input.group_title|escape:'quotes':'UTF-8'}</h4>
            {/if}
            {if $input.name == 'ETS_MG_DATA_TO_MIGRATE'}
                <div class="form-group data-to-migrate">
                    <div class="ets_mg_import_info">
                        <div class="ets_mg_wrap">
                            <div class="title_form col-sm-6 col-xs-6">{l s='Data entities' mod='ets_migrator'}</div>
                            <div class="title_form title_form_items col-sm-6 col-xs-6">{l s='Item count' mod='ets_migrator'}</div>
                            {include file="./data-migrate.tpl" class='info_data_source' type='column' input_checkbox=0}
                        </div>
                        <div class="ets_mg_bottom viewmore_form">
                            <span class="viewmore_button more active">{l s='View more' mod='ets_migrator'}</span>
                            <span class="viewmore_button less">{l s='View less' mod='ets_migrator'}</span>
                        </div>
                    </div>
                </div>
                <div class="form-group wrap-migrate">
                    <div class="table">
                        <div class="table-cell">
                            <div class="ets_em_form">
                                <div class="ets_em_form_group advanced_settings">
                                    <div class="ets_em_panel_header">
                                        <div class="ets_em_header_block">
                                            <h3 class="ets_em_title_block">{l s='Advanced settings' mod='ets_migrator'}</h3>
                                        </div>
                                    </div>
                                    <div class="form-group data-entities advanced_settings">
                                        <h4 class="ets_em_title_block">{l s='Data entities to migrate' mod='ets_migrator'}</h4>
                                        <div class="ets_mg_export_import_form">
                                            {include file="./data-migrate.tpl" class='select_data_import' type='list' input_checkbox=1}
                                        </div>
                                    </div>
                                    <div class="form-group ets-em-shop-mapping advanced_settings">
                                        <h4 class="ets_em_title_block">{l s='Shop mapping' mod='ets_migrator'}</h4>
                                        <input id="ETS_MG_SHOPS_MAPPING" type="hidden" name="ETS_MG_SHOPS_MAPPING" value=""/>
                                        <div class="ets-em-shop-mapping-list"></div>
                                    </div>
            {elseif $input.name == 'ETS_MG_PROCESS_MIGRATION'}
                <div class="form-group process-migration">
                    {include file="./migrate-process.tpl"}
                </div>
            {elseif $input.name == 'ETS_MG_MIGRATION_DONE'}
                <div class="form-group migration-done">
                    {include file="./migrate-complete.tpl"}
                </div>
            {else}{$smarty.block.parent}{/if}
        {/if}
        {if $input.name == 'ETS_MG_MIGRATION_DONE'}
            </div>
        {/if}
    {else}{$smarty.block.parent}{/if}
{/block}

{block name="footer"}
    {if isset($partial) && $partial|trim !== ''}
        <div class="form-footer">
            <input type="hidden" value="{$partial|escape:'html':'UTF-8'}" name="partial">
            <button name="module_form_cancel_btn" type="button" class="btn btn-default ets_em_popup_cancel no_svg_icon">{l s='Close' mod='ets_migrator'}</button>
            <button type="submit" value="1" class="ets_em_form_submit_btn no_svg_icon ets_em_setting" name="submitConfig">{l s='Save' mod='ets_migrator'}</button>
        </div>
    {else}
        <div class="panel-form-footer step1" data-step="{$input.step|escape:'quotes':'UTF-8'}">
            <button type="submit" value="1" class="ets_em_form_submit_btn" name="submitConfig">
                {l s='Next' mod='ets_migrator'}
                <i class="ets_svg_icon ets_svg_fill_white">
                    <svg class="w_18 h_18" width="18" height="18" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1728 893q0 14-10 24l-384 354q-16 14-35 6-19-9-19-29v-224h-1248q-14 0-23-9t-9-23v-192q0-14 9-23t23-9h1248v-224q0-21 19-29t35 5l384 350q10 10 10 23z"/></svg>
                </i>
            </button>
        </div>
        <div class="panel-form-footer step2">
            <button type="submit" id="ets_em_advance_popup" class="ets_em_advanced_settings pull-right">
                {l s='Next' mod='ets_migrator'}
                <i class="ets_svg_icon ets_svg_fill_white">
                    <svg class="w_18 h_18" width="18" height="18" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1728 893q0 14-10 24l-384 354q-16 14-35 6-19-9-19-29v-224h-1248q-14 0-23-9t-9-23v-192q0-14 9-23t23-9h1248v-224q0-21 19-29t35 5l384 350q10 10 10 23z"/></svg>
                </i>
            </button>
            <button type="submit" class="back_step1">

                    <svg class="w_18 h_18" width="18" height="18" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1792 800v192q0 14-9 23t-23 9h-1248v224q0 21-19 29t-35-5l-384-350q-10-10-10-23 0-14 10-24l384-354q16-14 35-6 19 9 19 29v224h1248q14 0 23 9t9 23z"/></svg>
                 {l s='Back' mod='ets_migrator'}
            </button>
        </div>
    {/if}
    {$smarty.block.parent}
{/block}

{block name="after"}
    {if isset($infos) && is_array($infos) && count($infos) > 0}
        <script type="text/javascript">
            ETS_EM_DATA_INFO_SOURCE = {$infos|json_encode};
        </script>
    {/if}
    {if !isset($partial) || $partial|trim == ''}
        <div class="ets_header_module">
            <ul class="ets_header_link_action">
                <li class="ets-em-menu">
                    <span>
                        <i class="ets_svg_icon ets_svg_fill_violet">
                            <svg class="w_20 h_20" width="20" height="20" viewBox="0 0 2048 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1344 928q0-14-9-23t-23-9h-224v-352q0-13-9.5-22.5t-22.5-9.5h-192q-13 0-22.5 9.5t-9.5 22.5v352h-224q-13 0-22.5 9.5t-9.5 22.5q0 14 9 23l352 352q9 9 23 9t23-9l351-351q10-12 10-24zm640 224q0 159-112.5 271.5t-271.5 112.5h-1088q-185 0-316.5-131.5t-131.5-316.5q0-130 70-240t188-165q-2-30-2-43 0-212 150-362t362-150q156 0 285.5 87t188.5 231q71-62 166-62 106 0 181 75t75 181q0 76-41 138 130 31 213.5 135.5t83.5 238.5z"/></svg>
                        </i> {l s='Downloads' mod='ets_migrator'}
                    </span>
                    <ul class="ets-em-menu-child">
                        <li class="ets-em-menu-child-item">
                            <a href="{$download_plugin_link|cat:'&file=ets_migrate_connector.zip'|escape:'quotes':'UTF-8'}" rel="noopener noreferrer" target="_blank">
                                <i class="ets_svg_icon ets_svg_fill_violet">
                                    <svg class="w_18 h_18" width="18" height="18" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M836 1169l-15 368-2 22-420-29q-36-3-67-31.5t-47-65.5q-11-27-14.5-55t4-65 12-55 21.5-64 19-53q78 12 509 28zm-387-586l180 379-147-92q-63 72-111.5 144.5t-72.5 125-39.5 94.5-18.5 63l-4 21-190-357q-17-26-18-56t6-47l8-18q35-63 114-188l-140-86zm1231 517l-188 359q-12 29-36.5 46.5t-43.5 20.5l-18 4q-71 7-219 12l8 164-230-367 211-362 7 173q170 16 283 5t170-33zm-785-924q-47 63-265 435l-317-187-19-12 225-356q20-31 60-45t80-10q24 2 48.5 12t42 21 41.5 33 36 34.5 36 39.5 32 35zm655 307l212 363q18 37 12.5 76t-27.5 74q-13 20-33 37t-38 28-48.5 22-47 16-51.5 14-46 12q-34-72-265-436l313-195zm-143-226l142-83-220 373-419-20 151-86q-34-89-75-166t-75.5-123.5-64.5-80-47-46.5l-17-13 405 1q31-3 58 10.5t39 28.5l11 15q39 61 112 190z"/></svg>
                                </i> {l s='PrestaShop Connector module' mod='ets_migrator'}
                            </a>
                        </li>
                        <li class="ets-em-menu-child-item">
                            <a href="{$download_plugin_link|cat:'&file=ets_passwordkeeper.zip'|escape:'quotes':'UTF-8'}" rel="noopener noreferrer" target="_blank">
                                <i class="ets_svg_icon ets_svg_fill_violet">
                                    <svg class="w_18 h_18" width="18" height="18" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1344 960v-640h-448v1137q119-63 213-137 235-184 235-360zm192-768v768q0 86-33.5 170.5t-83 150-118 127.5-126.5 103-121 77.5-89.5 49.5-42.5 20q-12 6-26 6t-26-6q-16-7-42.5-20t-89.5-49.5-121-77.5-126.5-103-118-127.5-83-150-33.5-170.5v-768q0-26 19-45t45-19h1152q26 0 45 19t19 45z"/></svg>
                                </i> {l s='PrestaShop Password Keeper module' mod='ets_migrator'}
                            </a>
                        </li>
                    </ul>
                </li>
                <li>
                    <a href="{$download_plugin_link|cat:'&file='|cat:$document_file|escape:'quotes':'UTF-8'}" rel="noopener noreferrer" target="_blank">
                        <i class="ets_svg_icon ets_svg_fill_violet">
                            <svg class="w_16 h_16" width="16" height="16" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1596 380q28 28 48 76t20 88v1152q0 40-28 68t-68 28h-1344q-40 0-68-28t-28-68v-1600q0-40 28-68t68-28h896q40 0 88 20t76 48zm-444-244v376h376q-10-29-22-41l-313-313q-12-12-41-22zm384 1528v-1024h-416q-40 0-68-28t-28-68v-416h-768v1536h1280zm-514-593q33 26 84 56 59-7 117-7 147 0 177 49 16 22 2 52 0 1-1 2l-2 2v1q-6 38-71 38-48 0-115-20t-130-53q-221 24-392 83-153 262-242 262-15 0-28-7l-24-12q-1-1-6-5-10-10-6-36 9-40 56-91.5t132-96.5q14-9 23 6 2 2 2 4 52-85 107-197 68-136 104-262-24-82-30.5-159.5t6.5-127.5q11-40 42-40h22q23 0 35 15 18 21 9 68-2 6-4 8 1 3 1 8v30q-2 123-14 192 55 164 146 238zm-576 411q52-24 137-158-51 40-87.5 84t-49.5 74zm398-920q-15 42-2 132 1-7 7-44 0-3 7-43 1-4 4-8-1-1-1-2-1-2-1-3-1-22-13-36 0 1-1 2v2zm-124 661q135-54 284-81-2-1-13-9.5t-16-13.5q-76-67-127-176-27 86-83 197-30 56-45 83zm646-16q-24-24-140-24 76 28 124 28 14 0 18-1 0-1-2-3z"/></svg>
                        </i> {l s='Documentation' mod='ets_migrator'}
                    </a>
                </li>
                <li>
                    <a href="{$youtube_link nofilter}" rel="noopener noreferrer" target="_blank">
                        <i class="ets_svg_icon ets_svg_fill_violet">
                            <svg class="w_16 h_16" width="16" height="16" viewBox="0 0 1792 1792" xmlns="http://www.w3.org/2000/svg"><path d="M1792 352v1088q0 42-39 59-13 5-25 5-27 0-45-19l-403-403v166q0 119-84.5 203.5t-203.5 84.5h-704q-119 0-203.5-84.5t-84.5-203.5v-704q0-119 84.5-203.5t203.5-84.5h704q119 0 203.5 84.5t84.5 203.5v165l403-402q18-19 45-19 12 0 25 5 39 17 39 59z"/></svg>
                        </i> {l s='Tutorial video' mod='ets_migrator'}
                    </a>
                </li>
            </ul>
        </div>
        <div class="ets_em_overload">
            <div class="table">
                <div class="table-cell">
                    <div class="ets_em_form">
                        <div class="ets_em_form_header">
                            <svg class="w_30 h_30" width="30" height="30" viewBox="0 0 2048 1792" xmlns="http://www.w3.org/2000/svg"><path d="M960 896q0-106-75-181t-181-75-181 75-75 181 75 181 181 75 181-75 75-181zm768 512q0-52-38-90t-90-38-90 38-38 90q0 53 37.5 90.5t90.5 37.5 90.5-37.5 37.5-90.5zm0-1024q0-52-38-90t-90-38-90 38-38 90q0 53 37.5 90.5t90.5 37.5 90.5-37.5 37.5-90.5zm-384 421v185q0 10-7 19.5t-16 10.5l-155 24q-11 35-32 76 34 48 90 115 7 11 7 20 0 12-7 19-23 30-82.5 89.5t-78.5 59.5q-11 0-21-7l-115-90q-37 19-77 31-11 108-23 155-7 24-30 24h-186q-11 0-20-7.5t-10-17.5l-23-153q-34-10-75-31l-118 89q-7 7-20 7-11 0-21-8-144-133-144-160 0-9 7-19 10-14 41-53t47-61q-23-44-35-82l-152-24q-10-1-17-9.5t-7-19.5v-185q0-10 7-19.5t16-10.5l155-24q11-35 32-76-34-48-90-115-7-11-7-20 0-12 7-20 22-30 82-89t79-59q11 0 21 7l115 90q34-18 77-32 11-108 23-154 7-24 30-24h186q11 0 20 7.5t10 17.5l23 153q34 10 75 31l118-89q8-7 20-7 11 0 21 8 144 133 144 160 0 8-7 19-12 16-42 54t-45 60q23 48 34 82l152 23q10 2 17 10.5t7 19.5zm640 533v140q0 16-149 31-12 27-30 52 51 113 51 138 0 4-4 7-122 71-124 71-8 0-46-47t-52-68q-20 2-30 2t-30-2q-14 21-52 68t-46 47q-2 0-124-71-4-3-4-7 0-25 51-138-18-25-30-52-149-15-149-31v-140q0-16 149-31 13-29 30-52-51-113-51-138 0-4 4-7 4-2 35-20t59-34 30-16q8 0 46 46.5t52 67.5q20-2 30-2t30 2q51-71 92-112l6-2q4 0 124 70 4 3 4 7 0 25-51 138 17 23 30 52 149 15 149 31zm0-1024v140q0 16-149 31-12 27-30 52 51 113 51 138 0 4-4 7-122 71-124 71-8 0-46-47t-52-68q-20 2-30 2t-30-2q-14 21-52 68t-46 47q-2 0-124-71-4-3-4-7 0-25 51-138-18-25-30-52-149-15-149-31v-140q0-16 149-31 13-29 30-52-51-113-51-138 0-4 4-7 4-2 35-20t59-34 30-16q8 0 46 46.5t52 67.5q20-2 30-2t30 2q51-71 92-112l6-2q4 0 124 70 4 3 4 7 0 25-51 138 17 23 30 52 149 15 149 31z"></path></svg>
                            <h3 class="ets_em_title_block">{l s='Settings' mod='ets_migrator'}</h3>
                            <span class="ets_em_popup_cancel"></span>
                        </div>
                        <div class="ets_em_form_wrap"></div>
                    </div>
                </div>
            </div>
        </div>
    {/if}
{/block}







